function [ xi yi L d2r r2t t2f f2tool] = deltaParams( )
%deltaParams returns parameters of delta robot
%   

%length of parallel legs
L = 440.35040068; %mm

%radius of base
R = 217.86092405; %mm

%radius of mobile platform
r = 50; %mm

%leg indices
i = [1 2 3];

%leg angles
ni = (2*i-1)*pi/3;

%leg base positions (using convention that all legs intersect at the same
%point on the mobile platform)
xi = (R-r)*cos(ni);
yi = (R-r)*sin(ni);

% vector from the delta mobile platform to the roll joint center
d2r = [42.235;0;58.180]; %mm

%vector from the roll joint to the tilt joint
r2t = [589.600; 0; -13.049]; %mm

%vector from the tilt joint to the force sensor origin
t2f = [35.09; 0; 25]; %mm

%tool tip offset
f2tool = [-70.617; 0; -147.345];%[0;0;0];%[19; 0; -220];
%Rtool = 
end

